/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.LinkLayerCompTest;

import com.quantumdata.LinkLayerCompTest.DPPreferredTimingPanel;
import com.quantumdata.LinkLayerCompTest.DPVideoTimingsPanel;
import com.quantumdata.LinkLayerCompTest.llctGui;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.widgets.QDCheckBox;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JComboBox;

public abstract class DPBasePanel
extends QDPanel {
    private static final long serialVersionUID = 411818507608L;
    protected JComboBox aMaxLaneCount;
    protected QDLabel aMaxLaneCountLabel;
    protected JComboBox aMaxLinkRate;
    protected QDLabel aMaxLinkRateLabel;
    protected QDCheckBox aExtensionSupported;
    protected QDLabel aExtensionSupportedLabel;
    protected QDCheckBox aFixedTimingDevice;
    protected DPVideoTimingsPanel aVideoTimingsPanel;
    protected QDLabel aVideoTimingsPanelLabel;
    protected DPPreferredTimingPanel aPreferredTimingPanel;
    protected QDLabel aPreferredTimingPanelLabel;
    protected QDCheckBox aRGBVesa;
    protected QDCheckBox aRGBCea;
    protected QDCheckBox aYCbCr444;
    protected QDCheckBox aYCbCr422;
    protected llctGui mainWin;

    public DPBasePanel(llctGui llctGui2) {
        this.mainWin = llctGui2;
        this.aMaxLaneCount = new JComboBox();
        this.aMaxLaneCount.addItem("1");
        this.aMaxLaneCount.addItem("2");
        this.aMaxLaneCount.addItem("4");
        this.aMaxLaneCountLabel = new QDLabel("Maximum Lane Count:");
        this.aMaxLinkRate = new JComboBox();
        this.aMaxLinkRate.addItem("1.62 Gbps");
        this.aMaxLinkRate.addItem("2.7 Gbps");
        this.aMaxLinkRateLabel = new QDLabel("Maximum Link Rate:");
        this.aExtensionSupportedLabel = new QDLabel("Test Automation DPCD Extension:");
        this.aExtensionSupported = new QDCheckBox("Supported?");
        this.aExtensionSupported.setFont(new Font("SansSerif", 0, 10));
        this.aRGBVesa = new QDCheckBox("RGB VESA");
        this.aRGBCea = new QDCheckBox("RGB CEA");
        this.aYCbCr444 = new QDCheckBox("YCbCr 4:4:4");
        this.aYCbCr422 = new QDCheckBox("YCbCr 4:2:2");
        Font font = new Font("SansSerif", 0, 10);
        this.aRGBVesa.setFont(font);
        this.aRGBCea.setFont(font);
        this.aYCbCr444.setFont(font);
        this.aYCbCr422.setFont(font);
        this.aFixedTimingDevice = new QDCheckBox("Device is Fixed Timing");
        this.aFixedTimingDevice.setFont(new Font("SansSerif", 0, 10));
        this.aVideoTimingsPanelLabel = new QDLabel("Video Timings/Color Formats:");
        this.aVideoTimingsPanel = new DPVideoTimingsPanel(this.mainWin);
        this.aPreferredTimingPanelLabel = new QDLabel("Device Preferred Timing");
        this.aPreferredTimingPanel = new DPPreferredTimingPanel(this.mainWin);
    }

    public static GridBagConstraints createGridBagConstraints(int n, int n2, int n3, int n4, int n5) {
        int n6 = 6;
        int n7 = n5 == 22 ? 10 : 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = n;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.fill = n4;
        gridBagConstraints.insets = new Insets(0, 0, n6, n7);
        gridBagConstraints.anchor = n5;
        return gridBagConstraints;
    }

    public abstract void reset();

    public void UpdateStatus(String string) {
        if (this.aFixedTimingDevice.isSelected()) {
            this.aPreferredTimingPanel.UpdateStatus(string);
        } else {
            this.aVideoTimingsPanel.UpdateStatus(string);
        }
        try {
            String string2;
            int n = this.mainWin.getInt(string + ":lmlc?");
            for (int i = 0; i < this.aMaxLaneCount.getItemCount(); ++i) {
                if (n != Integer.parseInt((String)this.aMaxLaneCount.getItemAt(i))) continue;
                this.aMaxLaneCount.setSelectedIndex(i);
                break;
            }
            if ((string2 = this.mainWin.sendCmd(string + ":lmbr?")).lastIndexOf("High Rate") != -1) {
                this.aMaxLinkRate.setSelectedIndex(1);
            } else {
                this.aMaxLinkRate.setSelectedIndex(0);
            }
            n = this.mainWin.getInt(string + ":taed?");
            this.aExtensionSupported.setSelected(n != 0);
            n = this.mainWin.getInt(string + ":llcr?");
            this.aRGBVesa.setSelected(n != 0);
            n = this.mainWin.getInt(string + ":llrc?");
            this.aRGBCea.setSelected(n != 0);
            n = this.mainWin.getInt(string + ":lly1?");
            this.aYCbCr444.setSelected(n != 0);
            n = this.mainWin.getInt(string + ":lly2?");
            this.aYCbCr422.setSelected(n != 0);
            n = this.mainWin.getInt(string + ":llft?");
            this.aFixedTimingDevice.setSelected(n != 0);
        }
        catch (InstrumentException instrumentException) {
            return;
        }
    }

    public void SendBackStatus(String string) {
        if (this.aFixedTimingDevice.isSelected()) {
            this.aPreferredTimingPanel.SendBackStatus(string);
        } else {
            this.aVideoTimingsPanel.SendBackStatus(string);
        }
        try {
            this.mainWin.sendCmd(string + ":llft " + (this.aFixedTimingDevice.isSelected() ? "1" : "0"));
            this.mainWin.sendCmd(string + ":llcr " + (this.aRGBVesa.isSelected() ? "1" : "0"));
            this.mainWin.sendCmd(string + ":llrc " + (this.aRGBCea.isSelected() ? "1" : "0"));
            this.mainWin.sendCmd(string + ":lly1 " + (this.aYCbCr444.isSelected() ? "1" : "0"));
            this.mainWin.sendCmd(string + ":lly2 " + (this.aYCbCr422.isSelected() ? "1" : "0"));
            this.mainWin.sendCmd(string + ":lmlc " + (String)this.aMaxLaneCount.getSelectedItem());
            this.mainWin.sendCmd(string + ":lmbr " + this.aMaxLinkRate.getSelectedIndex());
            this.mainWin.sendCmd(string + ":taed " + (this.aExtensionSupported.isSelected() ? "1" : "0"));
        }
        catch (InstrumentException instrumentException) {
            return;
        }
    }
}

